    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    //usata in tutte le pagine dell'amministrazione quando l'utente vuole cambiare password
    function validazionePassword() {
        var pass  = $('#cambiaPassword').val();
        var pass2 = $('#cambiaPassword2').val();
        if(pass==pass2 && pass!="") {
            document.formCambiaPassword.submit();
        }
        else if(pass=="") {
            alert("il campo password è vuoto");
        }
        else {
            alert("le password devono coincidere");
        }
    }

    function aggiungiCommento(bloccaLink,inRispostaA) {
        if(inRispostaA==0) {
            var offsetId = "";
        }
        else {
            var offsetId = ""+inRispostaA;
        }

        var checboxPrivacy = document.getElementById("accettazioneTerminiCondizioni"+offsetId);
        if(checboxPrivacy.checked==false) {            
            alert("Devi accettare le condizioni sulla privacy");
        }
        else {
            var email = $('#email'+offsetId).val();
            var nome  = $('#nome'+offsetId).val();
            var testo = $('#testo'+offsetId).val();
            var idArticolo = $('#idContenuto').val();

            if(testo.indexOf("<script>")>-1 || testo.indexOf("<iframe")>-1 || testo.indexOf("<img")>-1) {
                alert("Rilevato tentativo di javascript injection: elimina il codice javascript prima di commentare");
            }
            else if(nome.indexOf("<script>")>-1 || nome.indexOf("<iframe")>-1 || nome.indexOf("<img")>-1) {
                alert("Rilevato tentativo di javascript injection: elimina il codice javascript prima di commentare");
            }
            else if(email.indexOf("<script>")>-1 || email.indexOf("<iframe")>-1 || email.indexOf("<img")>-1) {
                alert("Rilevato tentativo di javascript injection: elimina il codice javascript prima di commentare");
            }
            else if(nome.length<1) {
                alert("inserisci il nome");
            }
            else if(email.length<1) {
                alert("inserisci l'email, tranquillo non la pubblicheremo ;)");
                alert(email);
            }
            else if(email.indexOf("@")<1) {
                alert("inserisci un indirizzo email corretto, tranqillo non lo pubblicheremo ;)");
            }
            else if (testo.length<1) {
                alert("inserisci il testo del commento");
            }
            else {
                if(bloccaLink=="si") {
                    if(testo.indexOf("http")>-1 || testo.indexOf("https")>-1 || testo.indexOf("www.")>-1) {
                        alert("Non è consentito inviare link. Eliminalo prima di commentare");
                    }
                    else {
                        document.getElementById("spanPulsanteAggiungiCommento").class = "spinner-border spinner-border-sm mr-2";
                        document.getElementById("pulsanteAggiungiCommento").disabled  = true;
                        
                        $.ajax({
                            type:"POST",
                            url:"controller/controllerCommenti.php",
                            data:{
                                operazione:"crea",
                                idContenuto:idArticolo,
                                inRispostaA:inRispostaA,
                                email:email,
                                nome:nome,
                                testo:testo
                            },
                            success:function(result) {
                                var vecchioCodice = $("#commenti").html();
                                $("#commenti").html(vecchioCodice+result);
                                location.href = "#ultimoCommento";
                                
                                document.getElementById("spanPulsanteAggiungiCommento").class = "";
                                document.getElementById("pulsanteAggiungiCommento").disabled  = false;
                                $('#email'+offsetId).val("");
                                $('#nome'+offsetId).val("");
                                $('#testo'+offsetId).val("");
                            },
                            error: function() {
                                alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                            }
                        });
                    }
                }
                else {
                    $.ajax({
                        type:"POST",
                        url:"controller/controllerCommento.php",
                        data:{
                            operazione:"crea",
                            idContenuto:idArticolo,
                            email:email,
                            nome:nome,
                            testo:testo
                        },
                        success:function(result) {
                            var vecchioCodice = $("#commenti").html();
                            $("#commenti").html(vecchioCodice+result);
                        },
                        error: function() {
                            alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                        }
                    });
                }
            }
        }
    }

    //funzione di invio dati. Titolo e testo sono campi obbligatori, se non sono stati inseriti viene visualizzato un messaggio
    function salvaContenuto() {
        if($('#titoloPagina').val()=="") {
            alert("Inserisci il titolo");
        }
        else {
            document.formCreaPagina.submit();
        }
    }
    
    //funzione di invio dati. Titolo e testo sono campi obbligatori, se non sono stati inseriti viene visualizzato un messaggio
    function pubblicaContenuto() {
        if($('#titoloPagina').val()=="") {
            alert("Inserisci il titolo");
        }
        else {
            document.getElementById("statoPubblicato").checked = true;
            document.formCreaPagina.submit();
        }
    }
        
    /*
     * funzione per la sottomissione delle form
     * 
     * il parametro "operazione" determina l'url dove inviare i dati
     */ 
    function inviaDatiForm(moduloContatto,richiediAccettazioneCondizioniPrivacy,urlRedirect,operazione) {
        var valida   = true;
        var nomeForm = "form"+moduloContatto;
        var form     = document.getElementById(nomeForm);
        
        var i, j, q = [];
        for (i = 0; i <= form.elements.length - 1; i++) {
            if (form.elements[i].name === "") {
                continue;
            }
            switch (form.elements[i].nodeName) {
                    case 'INPUT':
                        switch (form.elements[i].type) {
                        case 'text':
                            if(form.elements[i].hasAttribute('required') && form.elements[i].value.length<1) {
                                alert("Il campo "+ form.elements[i].name +" è richiesto");
                                valida=false;
                            }
                            else {                            
                               q.push(form.elements[i].name + ": " + encodeURIComponent(form.elements[i].value));
                            }
                            break;
                        case 'email':
                            if(form.elements[i].hasAttribute('required') && form.elements[i].value.length<1) {
                                alert("Il campo "+ form.elements[i].name +" è richiesto");
                                valida=false;
                            }
                            else {                            
                               q.push(form.elements[i].name + ": " + encodeURIComponent(form.elements[i].value));
                            }
                            break;
                        case 'date':
                            q.push(form.elements[i].name + ": " + encodeURIComponent(form.elements[i].value));
                            break;
                        case 'time':
                            q.push(form.elements[i].name + ": " + encodeURIComponent(form.elements[i].value));
                            break;
                        case 'hidden':
                        case 'password':
                        case 'button':
                        case 'reset':
                        case 'checkbox':
                            if(form.elements[i].hasAttribute('required') && form.elements[i].checked==false) {
                                alert("Il campo "+ form.elements[i].name +" è richiesto");
                                valida=false;
                            }
                            else {                            
                               q.push(form.elements[i].name + ": " + encodeURIComponent(form.elements[i].value));
                            }
                            break;
                        case 'radio':
                             if (form.elements[i].checked) {
                                 q.push(form.elements[i].name + ": " + encodeURIComponent(form.elements[i].value));
                             }
                             break;
                        }
                        break;
                    case 'file':
                        break;
                    case 'TEXTAREA':
                        if(form.elements[i].hasAttribute('required') && form.elements[i].value.length<1) {
                            alert("Il campo "+ form.elements[i].name +" è richiesto");
                            valida=false;
                        }
                        else {                            
                           q.push(form.elements[i].name + ": " + encodeURIComponent(form.elements[i].value));
                        }
                        break;
                    case 'SELECT':
                        switch (form.elements[i].type) {
                        case 'select-one':
                             q.push(form.elements[i].name + "=" + encodeURIComponent(form.elements[i].value));
                             break;
                        case 'select-multiple':
                             for (j = form.elements[i].options.length - 1; j >= 0; j = j - 1) {
                                 if (form.elements[i].options[j].selected) {
                                     q.push(form.elements[i].name + ": " + encodeURIComponent(form.elements[i].options[j].value));
                                 }
                             }
                             break;
                        }
                        break;
            }
            data = q.join("<br>");
        }
        if(richiediAccettazioneCondizioniPrivacy=="si" && valida==true) {
            var checboxPrivacy = document.getElementById("accettazioneTerminiCondizioni");
            if(checboxPrivacy.checked==false) {            
                alert("Devi accettare le condizioni sulla privacy");
            }
            else {
                document.getElementById("pulsanteForm"+moduloContatto).disabled  = true;
                        
                if(valida==true) {
                    $.ajax({
                        type:"POST",
                        url:"controller/controllerSottomissioniForm.php",
                        data:"idForm="+moduloContatto+"&operazione="+operazione+"&informazioniInserite="+data,
                        success:function(risposta) {
                            if(risposta==="ok" && (operazione==="inserisciDatoInvio" || operazione==="eseguiRicerca")) {
                                form.submit();
                            }
                            else if(risposta==="ok" && operazione==="eseguiRicercaAjax") {
                                eseguiRicercaAjax(); // questa funzione viene creata nel VisualizzatoreForm
                            }
                            else if(risposta==="ok" && operazione==="creaUtenteEInviaMail") {
                                creaUtenteInGeecomAdmin(); // questa funzione viene creata nel VisualizzatoreForm
                                
                                location.href = urlRedirect;
                            }  
                            else if(risposta==="ok") {
                                location.href = urlRedirect;
                            }
                            else {
                                alert(risposta);
                            }
                            
                            // riattivo il pulsante
                            document.getElementById("pulsanteAggiungiCommento"+moduloContatto).disabled  = false;
                        }
                    });
                }
            }
        }
        else {
            if(valida==true) {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerSottomissioniForm.php",
                    data:"idForm="+moduloContatto+"&operazione="+operazione+"&informazioniInserite="+data,
                    success:function(risposta) {
                        if(risposta==="ok" && (operazione==="inserisciDatoInvio" || operazione==="eseguiRicerca")) {
                            form.submit();
                        }
                        else if(risposta==="ok" && operazione==="eseguiRicercaAjax") {
                            eseguiRicercaAjax(); // questa funzione viene creata nel VisualizzatoreForm
                        }
                        else if(risposta==="ok" && operazione==="creaUtenteEInviaMail") {
                            creaUtenteInGeecomAdmin(); // questa funzione viene creata nel VisualizzatoreForm
                            
                            location.href = urlRedirect;
                        } 
                        else if(risposta==="ok") {
                            location.href = urlRedirect;
                        }
                        else {
                            alert(risposta);
                        }
                    }
                });
            }
        }    
    }
    
    function segnalaCommento(id) {
        $.ajax({
            type:"POST",
            url:"controller/controllerCommenti.php",
            data:{
                id:id,
                operazione:"segnala"
            },
            success:function(result) {
                alert(result);
            },
            error: function() {
                alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
            }
        });
    }

    // funzione usata per chiedere conferma dell'eliminazione dei commenti, viene usata
    // in home.php e in gestioneCommenti.php
    function eliminaCommento(idUtente,testo) {
        $('#myModalLabel3').text("Eliminare il commento?");
        document.getElementById("commentoDaEliminare").value = idUtente;
        $('#testoCommento').text(testo);
        $('#eliminaCommento').modal('show');
    }

    //funzione che elimina definitivamente il commento (si attiva quando l'utente clicca su elimina) 
    function eliminaCommentoDefinitivamente(pagina) {
        var percorsoAttuale = window.location.pathname;;
        var paginaCorrente = percorsoAttuale.substring(percorsoAttuale.lastIndexOf('/') + 1);
        
        var commento = document.getElementById("commentoDaEliminare").value;
        $.ajax({
            type:"POST",
            url:"../controller/controllerCommento.php",
            data:{
                id:commento,
                operazione:'elimina'
            },
            success:function(result) {
                if(paginaCorrente=="home.php") {
                    location.href="home.php?status=5";
                }
                else {
                    location.href="gestioneCommenti.php?status=5";
                }
            },
            error:function(){
                alert("errore");
            }
        });
    }

                    /*** FUNZIONI PER EFFETTUARE OPERAZIONI COMUNI ***/

    // funzione per modificare la posizione di un elemento
    // usata per modficare la posizione nelle colonne laterali
    // il campo tabella da aggiornare contiene la tabella da modificare, a seconda del valore
    // lo script modificherà la query di aggiornamento
    function modificaPosizione(tabellaDaAggiornare,idCampoInput,idVoceMenu) {
        var posizione = $('#'+idCampoInput).val();
        location.href = "operazioniComuni/aggiornaPosizione.php?tabellaDaAggiornare="+tabellaDaAggiornare+"&id="+idVoceMenu+"&posizione="+posizione;
    }

    // funzione per modificare il nome di un componente nelle colonne laterali
    // il campo tabella da aggiornare contiene la tabella da modificare, a seconda del valore
    // lo script modificherà la query di aggiornamento
    function modificaNomeComponente(tabellaDaAggiornare,idCampoInput,idVoceMenu) {
        var nomeComponente = $('#'+idCampoInput).val();
        location.href = "operazioniComuni/aggiornaNomeComponente.php?tabellaDaAggiornare="+tabellaDaAggiornare+"&id="+idVoceMenu+"&nomeComponente="+nomeComponente;
    }

    // funzione per modificare il percorso di un prodotto geecom
    // usata in impostazioni -> prodotti installati
    function modificaProdottoGeecom(idCampoInput,idProdotto) {
        var percorso = $('#'+idCampoInput).val();
        location.href = "impostazioni/aggiornaImpostazioniProdotti.php?percorso="+percorso+"&idProdotto="+idProdotto;
    }

    // funzione per modificare il percorso di un prodotto geecom
    // usata in impostazioni -> prodotti installati
    function cookieAccettati() {
        var CookieDate = new Date;
        CookieDate.setFullYear(CookieDate.getFullYear( ) +30);
        document.cookie = "cookieAccettati=si; expires=" + CookieDate.toGMTString( ) + ";";
    }
    
    /*
     * funzione per aggiornare tramite ajax le impostazioni sui cookie
     */
    function aggiornaImpostazioniCookie(id) {
        var attivaBarraCookie = "";
        var mostraPulsanteMaggioriInformazioni = "";
        var mostraPulsanteNonAccetto = "";
        if($('#attivaBarraCookie'+id)[0].checked===true) {
            attivaBarraCookie = "si";
        }
        else {
            attivaBarraCookie = "no";
        }
        
        if($('#mostraPulsanteMaggioriInformazioni'+id)[0].checked===true) {
            mostraPulsanteMaggioriInformazioni = "si";
        }
        else {
            mostraPulsanteMaggioriInformazioni = "no";
        }

        if($('#mostraPulsanteNonAccetto'+id)[0].checked===true) {
            mostraPulsanteNonAccetto = "si";
        }
        else {
            mostraPulsanteNonAccetto = "no";
        }
        
        //var testoBarraCookie = document.getElementById("testoBarraCookie").value;
        var testoBarraCookie = tinymce.activeEditor.getContent();
        var durataCookie     = document.getElementById("durataCookie"+id).value;
        var testoPulsanteAccetto = document.getElementById("testoPulsanteAccetto"+id).value;
        var testoPulsanteNonAccetto = document.getElementById("testoPulsanteNonAccetto"+id).value;
        var testoPulsanteMaggioriInformazioni = document.getElementById("testoPulsanteMaggioriInformazioni"+id).value;
        var headCodiciCookie = document.getElementById("headCodiciCookie"+id).value;
        var fineBodyCookie = document.getElementById("fineBodyCookie"+id).value;
        var paginaMaggioriImpostazioni = document.getElementById("paginaMaggioriImpostazioni"+id).value;
        
        $.ajax({
            type:"GET",
            url:"../controller/controllerImpostazioni.php",
            data:{
                id:id,
                operazione:'aggiornaImpoastazioniCookie',
                attivaBarraCookie:attivaBarraCookie,
                durataCookie:durataCookie,
                testoBarraCookie:testoBarraCookie,
                testoPulsanteAccetto:testoPulsanteAccetto,
                testoPulsanteNonAccetto:testoPulsanteNonAccetto,
                headCodiciCookie:headCodiciCookie,
                fineBodyCookie:fineBodyCookie,
                testoPulsanteMaggioriInformazioni:testoPulsanteMaggioriInformazioni,
                mostraPulsanteMaggioriInformazioni:mostraPulsanteMaggioriInformazioni,
                mostraPulsanteNonAccetto:mostraPulsanteNonAccetto,
                paginaMaggioriImpostazioni:paginaMaggioriImpostazioni
            },
            success:function(result) {
                alert(result);
            },
            error:function(){
              alert("errore");
            }
        });
    }
    
    /*
     * funzione che aggiorna i click ricevuti da un invito all'azione, e 
     * reindirizza l'utente nella pagina speifica
     */
    function gestisciClick(id, link,tipoOperazione) {
        $.ajax({
            type:"GET",
            url:"controller/controllerImpostazioni.php",
            data:{
                operazione:tipoOperazione,
                id:id
            },
            success:function() {
                location.href = link;
            },
            error:function(){
              alert("errore");
            }
        });
    }
    
    /*
     * funzione per settare i cookie, richiamata dal file nel template leggeCookie.php
     */
    function impostaCookie(numeroGiorni) {
        var d = new Date();
        d.setTime(d.getTime() + (numeroGiorni*24*60*60*1000));
        var scadenzaCookie = "expires="+ d.toUTCString();
        document.cookie = "leggecookie=leggecookie;"+scadenzaCookie;
        location.reload();
    }
    
    /*
     * form usata per rispondere ad un commento
     */
    function generaFormRispondi(divRisposta) {
        document.getElementById(divRisposta).className = "";
    }
    
    /*
     * questa funzione viene usata per creare un nuovo tag direttamente dalla
     * pagina articoli
     */
    function associaTagArticolo(idTag,idArticolo) {
        $.ajax({
            type:"POST",
            url:"../controller/controllerContenuti.php",
            data:{
                operazione:"associaArticoloAlTag",
                idTag:idTag,
                id:idArticolo
            },
            success:function(result) {
                if(result!="L'articolo è già associato a questo tag") {
                    $("#badgeTag"+idTag).addClass("hidden");
                    var vecchioCodice = $("#divTagArticolo").html();

                    if(vecchioCodice.indexOf("stringaNessunTag")>0) {
                        $("#divTagArticolo").html(result);
                    }
                    else {
                        $("#divTagArticolo").html(vecchioCodice+result);
                    }
                }
                else {
                    alert(result);
                }
            },
            error: function() {
                alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
            }
        });
    }
    
    /*
     * funzione per creare o modificare le categorie
     * prende in input il tipo di categoria e un prefisso da inserire nel percorso
     * per arrivare al controller
     */
    function operazioniCategoria(prefisso) {
        var operazione  = document.getElementById("operazione").value;
        var idCategoria = document.getElementById("idCategoria").value;
        var nome        = document.getElementById("nomeCategoria").value;
        if(operazione==="modifica") {
            var alias = document.getElementById("alias").value;
        }
        else {
            var alias = "";
        }
        var titoloPagina= document.getElementById("metaTitolo").value;
        var tipoCategoria= document.getElementById("tipo").value;
        
        var metaDescrizione = document.getElementById("metaDescrizioneCategoria").value;
        var cssAggiuntivo   = document.getElementById("cssAggiuntivo").value;
        var tipoVisualizzazione     = document.getElementById("tipoVisualizzazione").value;
        var numeroArticoliPerPagina = document.getElementById("numeroArticoliPerPagina").value;
        var categoriaMadre          = document.getElementById("categoriaMadre").value;
        var ordinamento             = document.getElementById("ordinamento").value;
        
        if(nome.length<1) {
            alert("Inserisci il nome della categoria")
        }
        else {
            $.ajax({
                type:"POST",
                url:prefisso+"controller/controllerCategorie.php",
                data:{
                    operazione:operazione,
                    id:idCategoria,
                    categoriaMadre:categoriaMadre,
                    nome:nome,
                    alias:alias,
                    titoloPagina:titoloPagina,
                    tipo:tipoCategoria,
                    metaDescrizione:metaDescrizione,
                    cssAggiuntivo:cssAggiuntivo,
                    tipoVisualizzazione: tipoVisualizzazione,
                    numeroArticoliPerPagina:numeroArticoliPerPagina,
                    ordinamento:ordinamento
                },
                success:function(esito) {
                    if(esito=="ok" || (tipoCategoria=="categoriaPortfolio" || tipoCategoria==="categoriaRisorsa")) {
                        location.reload();
                    }
                    else { // solo se ha creato una categoriaArticolo o ecommercel'utente viene rediretto alla pagina della categoria
                        var idCategoria = parseInt(esito);
                        location.href="creaCategoria.php?id="+idCategoria+"&status=200";
                    }
                },
                error:function(){
                    alert("errore");
                }
            });
        }
    }
    
    
    /*
     * Funzione per far aprire la popup di conferma per eliminare 
     * la categoria 
     */
    function apriPopupEliminaCategoria(idCategoria,nome) {
        document.getElementById("nomeCategoriaDaEliminare").innerHTML = nome;
        document.getElementById("categoriaDaEliminare").value = idCategoria;
        $('#modalEliminaCategoria').modal('show');
    }
            
    /*
     * Funzione per eliminare una categoria, 
     */
    function eliminaCategoria(prefisso) {
        $('#modalEliminaCategoria').modal('hide');
        var id = document.getElementById("categoriaDaEliminare").value;
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerCategorie.php",
            data:{
                operazione:'elimina',
                id:id
            },
            success:function(responso) {
                if(responso=="ok") {
                    document.getElementById("rigaCategoria"+id).className = "d-none";
                }
                else {
                    alert(responso);                
                    alert("c'è stato un errore nell'eliminazione della categoria")
                }
            },
            error:function(){
                alert("Errore nella comunicazione col server");
            }
        });
    }
    
    function modificaPosizioneCategoria(prefisso,idCampoInput,idCategoria,tipoCategoria) {
        var posizione = document.getElementById(idCampoInput).value;
        if(posizione>0) {
            eseguiChiamataModificaPosizioneCategoria(prefisso,idCategoria,posizione,tipoCategoria);
        }
        else {
            alert("Valore non valido, inserisci un numero maggiore di 0");
        }
    }

    function eseguiChiamataModificaPosizioneCategoria(prefisso,idCategoria,posizione,tipoCategoria) {
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerCategorie.php",
            data:{
                operazione:'aggiornaPosizione',
                id:idCategoria,
                nuovaPosizione:posizione
            },
            success:function(responso) {
                if(responso=="ok" && tipoCategoria=="categoriaArticolo") {                
                    location.href="gestioneCategorie.php?status=100";
                }
                else if(responso=="ok" && tipoCategoria=="ecommerce") {                
                    location.href="index.php?status=16";
                }
                else if(responso=="ok") {                
                    location.reload();
                }
                else {
                    alert("c'è stato un errore nell'eliminazione della categoria")
                }
            },
            error:function(){
                alert("Errore nella comunicazione col server");
            }
        });
    }
            
    function apriPopupEliminaImmagine(idDiv,percorso) {
        document.getElementById("idDiv").value            = idDiv;
        document.getElementById("percorsoImmagine").value = percorso;
        document.getElementById("immagineDaEliminare").src= percorso;
        $('#modalEliminaImmagine').modal('show');
    }
    
    function eliminaImmagine(prefisso) {
        var idDiv    = document.getElementById("idDiv").value;
        var percorso = document.getElementById("percorsoImmagine").value;
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerImmagini.php",
            data:{
                operazione:'eliminaFileImmagine',
                id:0,
                percorso:percorso
            },
            success:function(esito) {
                if(esito=="ok") {
                    document.getElementById(idDiv).className = "d-none";
                    $('#modalEliminaImmagine').modal('hide');
                }
            },
            error:function(){
              alert("errore");
            }
        });        
    }
    
    function eliminaFileRisorsa(prefisso) {
        var idDiv    = document.getElementById("idDivRisorsa").value;
        var percorso = document.getElementById("percorsoFileRisorsa").value;
    
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerRisorse.php",
            data:{
                operazione:'eliminaFileRisorsa',
                id:0,
                percorso:percorso
            },
            success:function(esito) {
                if(esito=="ok") {
                    document.getElementById(idDiv).className = "d-none";
                    $('#modalEliminaFile').modal('hide');
                }
            },
            error:function(){
              alert("errore");
            }
        });        
    }
    
    /*
     * Questa funzione consente di inserie nuovi componenti in un pannello laterale
     * prende in input il prefisso e il nome del pannello, poi usa la parola nomePannello 
     * per recuperare le informazione 
     */
    function aggiungiComponentePannello(prefisso,nomePannello) {
        var nomeInizialeMaiuscola = nomePannello.charAt(0).toUpperCase() + nomePannello.slice(1);
        var idComponente   = document.getElementById("idComponenteDaAggiungerePannello"+nomeInizialeMaiuscola).value;
        var nomeDaMostrare = document.getElementById("nomeComponenteDaAggiungerePannello"+nomeInizialeMaiuscola).value;
        
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerPannelliLaterali.php",
            data:{
                operazione:'aggiungiComponente',
                nomePannello:nomePannello,
                idComponente:idComponente,
                nomeDaMostrare:nomeDaMostrare
            },
            success:function(esito) {
                if(esito=="ok") {
                    
                    if(nomePannello=="destra") {
                        location.href = "impostazioni.php?status=231";
                    }
                    else if(nomePannello=="sinistra") {
                        location.href = "impostazioni.php?status=230";
                    }
                }
            },
            error:function(){
                alert("errore");
            }
        });  
    }
    
    function spostaComponentePannelloInput(prefisso,idElemento,nomePannello) {
        var posizione = $('#nuovaPosizioneComponentePannello'+idElemento).val();
        spostaComponentePannello(prefisso,idElemento,posizione,nomePannello);
    }

    function spostaComponentePannello(prefisso,idElemento,posizione,nomePannello) {
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerPannelliLaterali.php",
            data:{
                operazione:"spostaElemento",
                nomePannello:nomePannello,
                idElemento:idElemento,
                posizione:posizione
            },
            success:function(result) {
                if(result=="ok") {
                    aggiornaElencoComponentiPannello(prefisso,nomePannello);
                }
                else {
                    alert(result);
                }
            },
            error: function() {
                alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
            }
        });
    }
            
    /*
     * Aggiorna l'elenco dei componenti del pannello
     */
    function aggiornaElencoComponentiPannello(prefisso,nomePannello) {
        var nomeInizialeMaiuscola = nomePannello.charAt(0).toUpperCase() + nomePannello.slice(1);
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerPannelliLaterali.php",
            data:{
                operazione:"stampaComponentiPannello",
                nomePannello:nomePannello
            },
            success:function(result) {
                document.getElementById("elencoComponentiPannello"+nomeInizialeMaiuscola).innerHTML = result;
            },
            error: function() {
                alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
            }
        });
    }
            
    function apriPopupEliminaComponentePannello(id,nome,tipo) {
        document.getElementById("idComponentePannelloDaEliminare").value   = id;
        $("#nomeComponentePannelloDaEliminare").text(nome);
        $("#tipoComponentePannelloDaEliminare").text(tipo);
        $('#popupEliminazioneComponentePannello').modal('show');
    }
    
    function eliminaComponentePannello(prefisso) {
        var idComponente = document.getElementById("idComponentePannelloDaEliminare").value;
        
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerPannelliLaterali.php",
            data:{
                operazione:'eliminaComponente',
                idComponente:idComponente
            },
            success:function(esito) {
                if(esito=="ok") {
                    document.getElementById("componentePannello"+idComponente).className = "d-none";
                    $('#popupEliminazioneComponentePannello').modal('hide');
                }
            },
            error:function(){
              alert("errore");
            }
        });        
    }
    
    /*
     * Questa funzione viene usata nel modulo login, quando l'utente si registra
     */
    function controlloTerminiECondizioni() {
	var nome     = document.getElementById("nome").value;
	var cognome  = document.getElementById("cognome").value;
	var telefono = document.getElementById("telefono").value;
	var email    = document.getElementById("email").value;
	var passwd   = document.getElementById("password").value;
	var checkBox = document.getElementById("accettoTerminiECondizioni");
	var valida   = true;

	if(nome.length <1) {
            alert("Inserisci il nome");
            valida = false;
	}

	if(cognome.length <1 && valida==true) {
            alert("Inserisci il cognome");
            valida = false;
	}

	if(telefono.length <7) {
            alert("Inserisci un numero di telefono valido");
            valida = false;
	}

	if((email.length <1 || email.indexOf("@") <1)  && valida==true) {
            alert("Inserisci un'email valida");
            valida = false;
	}

	if(passwd.length <1) {
            alert("Inserisci la password");
            valida = false;
	}

	if(checkBox.checked != true && valida==true) {
            alert("Devi accettare i termini e condizioni per proseguire");
            valida = false;
	}

	if(valida==true) {
            document.formRegistrazione.submit();
	}
    }
    
    /*
     * funzioni per la gestione delle notifiche
     */
    function segnaNotificaComeLetta(prefisso,id) {
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerNotifiche.php",
            async:false,
            data:{
                operazione:"segnaComeLetta",
                id:id
            },
            success:function(risposta) {
                if(risposta=="ok") {
                    document.getElementById("divNotifica"+id).className = "d-none";
                }
                else {
                    alert(risposta);
                }
            }
        });
    }
    
    function segnaNotificaComeLettaConRedirect(prefisso,id,link) {
        segnaNotificaComeLetta(prefisso,id);
        location.href = link;
    }
    
    function mostraDivNotifiche() {
        document.getElementById("dropdown-notifiche").className = "shadow p-3";
        document.getElementById("campanellaNotifiche").removeEventListener("click", mostraDivNotifiche);
        document.getElementById("campanellaNotifiche").addEventListener("click", nascondiDivNotifiche);
        document.getElementById("main").addEventListener("click", nascondiDivNotifiche);
        document.getElementById("headerAdmin").addEventListener("click", nascondiDivNotifiche);
        document.getElementById("navbarCollapse").addEventListener("click", nascondiDivNotifiche);
        document.getElementById("barraSuperioreAdmin").addEventListener("click", nascondiDivNotifiche);
    }
    
    function nascondiDivNotifiche() {
        document.getElementById("dropdown-notifiche").className = "d-none";
        document.getElementById("campanellaNotifiche").addEventListener("click", mostraDivNotifiche);
        document.getElementById("campanellaNotifiche").removeEventListener("click", nascondiDivNotifiche);
    }
    
    /*
     * Questa funzione viene utilizzata modificare l'immagine di un elemento del componente.
     * Viene usata in tutti i componenti che hanno immagini
     */
    function modificaImmagineElementoComponente(idElemento,percorso) {
        $.ajax({
            type:"POST",
            url:"controller/controllerComponente.php",
            data:{
                operazione:"modificaImmagineElementoConPercorso",
                idElemento:idElemento,
                percorso:percorso
            },
            success:function(risposta) {
                if(risposta=="ok") {
                    document.getElementById("immagineElemento").src = "../../../"+percorso;
                }
                else {
                    alert(risposta);
                }
            }
        });
    }
    
    /*
     * Questa funzione viene utilizzata per gli elementi del portfolio, non effettua il caricamento dell'immagine
     * sul server ma nelle gallerie in altre situazioni
     */
    function rendiImmagineInEvidenzaContenuto(prefisso,idContenuto,percorso) {
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerContenuti.php",
            data:{
                operazione:"modificaImmagineInEvidenzaConPercorso",
                id:idContenuto,
                percorso:percorso
            },
            success:function(risposta) {
                if(risposta=="ok") {
                    document.getElementById("immagineInEvidenza").src = prefisso+percorso;
                }
                else {
                    alert(risposta);
                }
            }
        });
    }
    
    /*
     * Questa funzione viene utilizzata per tutti i tipi di categorie che consente
     * di salvare un'immagine in evidenza.
     */
    function cambiaImmagineInEvidenzaCategoria(prefisso,idContenuto,percorso) {
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerCategorie.php",
            data:{
                operazione:"modificaImmagineInEvidenzaConPercorso",
                id:idContenuto,
                percorso:percorso
            },
            success:function(risposta) {
                if(risposta=="ok") {
                    document.getElementById("immagineInEvidenza").src = prefisso+percorso;
                }
                else {
                    alert(risposta);
                }
            }
        });
    }
    
    /*
     * Questa funzione viene utilizzata per gli elementi del portfolio, nelle gallerie in altre situazioni dove è richiesto di
     * modificare la didascalia di un'immagine immagazzinata nella tabella geec_immagini
     */
    function modificaDidascaliaImmagine(prefisso,idImmagine) {
        var didascalia = $('#didascaliaImmagine'+idImmagine).val();
        
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerImmagini.php",
            data:{
                operazione:"modificaDidascalia",
                descrizione:didascalia,
                id:idImmagine
            },
            success:function(risposta) {
                if(risposta=="ok") {
                    $('#labelOperazioneCompletata').text("Didascalia aggiornata");
                    $('#modalOperazioneCompletata').modal('show');
                }
                else {
                    alert(risposta);
                }
            }
        });
    }
    
    /*
     * Questa funzione viene utilizzata per gli elementi del portfolio, nelle gallerie in altre situazioni dove è richiesto di
     * eliminare l'immagine immagazzinata nella tabella geec_immagini
     */
    function eliminaOccorrenzaImmagine(prefisso,id,percorso) {
        $('#idImmagineDaEliminare').val(id);
        document.getElementById("percorsoImmagineDaEliminare").src = prefisso+percorso;
        $('#modalEliminaImmagine').modal('show');
    }
    
    /*
     * Questa funzione esegue l'eliminazione di un'immagine.
     * 
     * Viene utilizzata per gli elementi del portfolio, nelle gallerie in altre situazioni dove è richiesto di
     * eliminare l'immagine immagazzinata nella tabella geec_immagini.
     */
    function eseguiEliminazioneOccorrenzaImmagine(prefisso) {
        var id = $('#idImmagineDaEliminare').val();
        
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerImmagini.php",
            data:{
                operazione:"eliminaSoloOccorrenza",
                id:id
            },
            success:function(risposta) {
                if(risposta=="ok") {
                    document.getElementById("immagineContenuto"+id).className = "d-none";
                    $('#modalEliminaImmagine').modal('hide');
                }
                else {
                    alert(risposta);
                }
            }
        });
    } 
    
    function modificaPosizioneImmagineContenutoDaInput(prefisso,idContenuto,idImmagine) {
        var posizione = document.getElementById("posizioneImmagineContenuto"+idImmagine).value;
        modificaPosizioneImmagineContenuto(prefisso,idContenuto,idImmagine,posizione);
    }

    function modificaPosizioneImmagineContenuto(prefisso,idContenuto,idImmagine,posizione) {
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerContenuti.php",
            data:{
                operazione:"modificaPosizioneImmagine",
                id:idContenuto,
                idImmagine:idImmagine,
                posizione:posizione
            },
            success:function(esito) {
                if(esito=="ok") {
                    aggiornaDivImmagini(); // questa funzione deve essere definita all'interno della pagina dell'elemento, non può essere generalizzata
                }
                else {
                    
                }
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
    
    function apriPopupEliminaUtenzaApi(id,nomeUtenza) {
        document.getElementById("idUtenzaDaEliminare").value = id;
        $('#nomeUtenzaDaEliminare').text(nomeUtenza);
        $('#popupEliminazioneUtenzaApi').modal('show');
    }
    
    function eseguiEliminazioneUtenzaApi(prefisso) {
        var id = document.getElementById("idUtenzaDaEliminare").value;
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerApi.php",
            data:{
                operazione:'elimina',
                id:id
            },
            success:function(esito) {
                if(esito=="ok") {
                    document.getElementById("utenzaApi"+id).className = "d-none";
                    $('#popupEliminazioneUtenzaApi').modal('hide');
                }
            },
            error:function(){
              alert("errore");
            }
        });        
    }
    
    function aggiungiUtenzaApi(prefisso) {
        var nomeUtenza    = document.getElementById("nomeUtenza").value;
        var codiceSegreto = document.getElementById("codiceSegretoUtenza").value;
        
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerApi.php",
            data:{
                operazione:"crea",
                nomeUtenza:nomeUtenza,
                codiceSegreto:codiceSegreto
            },
            success:function(esito) {
                if(esito=="ok") {
                    aggiornaDivUtenzeApi(); // questa funzione deve essere definita all'interno della pagina dell'elemento, non può essere generalizzata
                }
                else {
                    alert(esito);
                }
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
    
    function eseguiModificaUtenzaApi(prefisso) {
        var id            = document.getElementById("idUtenzaDaModificare").value;
        var nomeUtenza    = document.getElementById("modificaNomeUtenza").value;
        var codiceSegreto = document.getElementById("modificaCodiceSegretoUtenza").value;
        
        if(document.getElementById("modificaAttivaApi").checked) {        
            var attiva = "si";
        }
        else {
            var attiva = "no";
        }
        
        if(document.getElementById("modificaPermessiLettura").checked) {
            var permessiLettura = "si";
        }
        else {
            var permessiLettura = "no";
        }
        
        if(document.getElementById("modificaPermessiScrittura").checked) {
            var permessiScrittura = "si";
        }
        else {
            var permessiScrittura = "no";
        }
        
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerApi.php",
            data:{
                operazione:"modifica",
                id:id,
                nomeUtenza:nomeUtenza,
                codiceSegreto:codiceSegreto,
                attiva:attiva,
                permessiLettura:permessiLettura,
                permessiScrittura:permessiScrittura
            },
            success:function(esito) {
                if(esito=="ok") {
                    aggiornaDivUtenzeApi(); // questa funzione deve essere definita all'interno della pagina dell'elemento, non può essere generalizzata
                    $('#modalModificaUtenzaApi').modal('hide');
                }
                else {
                    alert(esito);
                }
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
    
    function eseguiModificaPasswordAmministratore(prefisso) {
        var nuovaPassword    = document.getElementById("nuovaPassword").value;
        var confermaPassword = document.getElementById("confermaNuovaPassword").value;
        
        if(nuovaPassword.length==0) {
            alert("Non è possibile impostare una password vuota");
        }
        else if(nuovaPassword==confermaPassword) {
            $.ajax({
                type:"POST",
                url:prefisso+"controller/controllerUtenti.php",
                data:{
                    operazione:'modificaPasswordAmministrazione',
                    nuovaPassword:nuovaPassword
                },
                success:function(esito) {
                    if(esito=="ok") {
                        $('#modalEliminaFile').modal('hide');
                        $('#labelOperazioneCompletata').text("Password cambiata con successo");
                        $('#modalOperazioneCompletata').modal('show');
                    }
                    else {
                        alert(esito);
                    }
                },
                error:function(){
                  alert("errore");
                }
            });
        }
        else {
            alert("Le password devono coincidere");
        }
    }
    
    function aggiornaCategorie(prefisso,tipo,idDivCategorie = "elencoCategorie") {
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerCategorie.php",
            data:{
                operazione:"stampaCategorie",
                tipo:tipo
            },
            success:function(result) {
                document.getElementById(idDivCategorie).innerHTML = result;
                $('#modifica-voce-menu').modal('hide');
            },
            error: function() {
                alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
            }
        });
    }
    
    function copiaNegliAppunti(testoDaCopiare) {
        navigator.clipboard.writeText(testoDaCopiare);
        alert("Testo copiato negli appunti");
    }
    
    function invertiStatoProdottoDaFrontEnd(tipo,id) {
        if(tipo=="contenuto") {
            var linkController = "controller/controllerContenuti.php";
        }
        else if(tipo=="annuncio") { // supporto al componente annunci
            var linkController = "controller/annunci/controllerAnnunci.php";
        }
        else {
            var linkController = "controller/ecommerce/controllerProdotti.php";
        }
        
        $.ajax({
            type:"POST",
            url:linkController,
            data:{
                operazione:"invertiStato",
                id:id
            },
            success:function(esito) {
                document.getElementById("statoContenutoBarraAdmin").className = "fas fa-circle "+esito;
                
                if(esito === "text-success") {
                    document.getElementById("labelStatoContenutoBarraAdmin").innerHTML = "Pubblicato";
                }
                else {
                    document.getElementById("labelStatoContenutoBarraAdmin").innerHTML = "Bozza";
                }
            },
            error: function() {
                alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
            }
        });
    }
    
    /*** 
     *  API DI SISTEMA 
     *  
     *  queste funzioni consentono di sfruttare le API di sistema di Geecom disponibili all'indirizzo api/apiDiSistema.php
     *  
     ***/
    
    /*
     * funzione per aggiornare tramite ajax un campo della tabella impostazioni
     */
    function aggiornaCampoImpostazioni(tabella,id,campo,valore) {
        $.ajax({
            type:"GET",
            url:"../controller/controllerImpostazioni.php",
            data:"operazione=aggiornaCampoTabella"+"&tabella="+tabella+"&id="+id+"&campo="+campo+"&valore="+valore,
            success:function(result) {

            },
            error:function(){
                alert("errore");
            }
        });
    }
    
    function aggiungiComponenteContenuto(prefisso,idContenuto,idComponente,tipoElemento) {
        $.ajax({
            type:"POST",
            url:prefisso+"api/apiSistema.php",
            async:false,
            data:{
                operazione:"aggiungiComponenteContenuto",
                idContenuto:idContenuto,
                idComponente:idComponente,
                tipoElemento:tipoElemento
            },
            success:function(esito) {

            },
            error:function(){
                alert("errore");
            }
        });
    }
    
    function aggiungiComponenteSezioneContenuto(prefisso,idContenuto,idComponente,idSezioneNuovoElemento,tabellaSezioneNuovoElemento,posizioneNuovoElementoSezione) {
        $.ajax({
            type:"POST",
            url:prefisso+"api/apiSistema.php",
            async:false,
            data:{
                operazione:"aggiungiComponenteSezioneContenuto",
                idContenuto:idContenuto,
                idComponente:idComponente,
                tabellaSezione:tabellaSezioneNuovoElemento,
                idSezioneNuovoElemento:idSezioneNuovoElemento,
                posizioneNuovoElementoSezione:posizioneNuovoElementoSezione
            },
            success:function(esito) {
                
            },
            error:function(){
                alert("errore");
            }
        });
    }
    
    function aggiornaDivComponentiContenuto(idContenuto) {
        $.ajax({
            type:"POST",
            url:"../controller/controllerContenuti.php",
            data:{
                operazione:"stampaComponentiContenuto",
                id:idContenuto
            },
            success:function(codice) {
                document.getElementById("componentiContenuto").innerHTML = codice;
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
    
    function apriModalModificaComponenteContenuto(prefisso,idComponente) {
        $.ajax({
            type:"POST",
            url:prefisso+"api/apiSistema.php",
            async:false,
            data:{
                operazione:"stampaCodiceModalModificaComponenteContenuto",
                percorsoBase:prefisso,
                idComponente:idComponente
            },
            success:function(esito) {
                document.getElementById("contenitoreCodiceModalModificaComponenteContenuto").innerHTML = esito;
                $('#modalModificaConfiguraComponenteContenuto').modal('show');
            },
            error:function(){
                alert("errore");
            }
        });
    }
    
    function eliminaComponenteContenuto(id,immagineComponente,nomeComponente,nomeElemento) {
        $('#componenteDaEliminare').val(id);
        document.getElementById("immagineComponenteDaEliminare").src = immagineComponente;
        $('#nomeComponenteDaEliminare').text(nomeComponente);
        document.getElementById("nomeElementoDaEliminare").innerHTML = nomeElemento;
        $('#modalEliminaComponenteContenuto').modal('show');
    }
    
    function eseguiEliminazioneComponenteContenuto() {
        var id = $('#componenteDaEliminare').val();
        $.ajax({
            type:"POST",
            url:"../api/apiSistema.php",
            data:{
                operazione:"eliminaComponenteContenuto",
                idComponente:id
            },
            success:function(result) {
                if(result=="ok") {
                    document.getElementById("componenteContenuto"+id).className = "d-none";
                    $('#modalEliminaComponenteContenuto').modal('hide');
                }
            },
            error: function() {
                alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
            }
        });
    }
    
    function modificaPosizioneComponenteDaInput(idContenuto,idComponente,tipoElemento) {
        var posizione = document.getElementById("posizioneComponente"+idComponente).value;
        modificaPosizioneComponenteContenuto(idContenuto,idComponente,tipoElemento,posizione);
    }
            
    function modificaPosizioneComponenteContenuto(idContenuto,idComponente,tipoElemento,posizione) {
        $.ajax({
            type:"POST",
            url:"../api/apiSistema.php",
            data:{
                operazione:"modificaPosizioneComponenteContenuto",
                idContenuto:idContenuto,
                idComponente:idComponente,
                tipoElemento:tipoElemento,
                posizione:posizione
            },
            success:function(esito) {
                if(esito=="ok") {                
                    aggiornaComponentiContenuto();
                }
                else {
                    
                }
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
    
    function invertiValoreComponenteNascosto(idComponente) {

        $.ajax({
            type:"POST",
            url:"../api/apiSistema.php",
            data:{
                operazione:"invertiValoreNascosto",
                idComponente:idComponente
            },
            success:function(esito) {
                if(esito=="Il componente è ora visibile") {
                    document.getElementById("componenteContenuto"+idComponente).className = "card mb-3";
                    document.getElementById("iconaInvertiValoreNascosto"+idComponente).className = "far fa-eye-slash";
                }
                else {
                    document.getElementById("componenteContenuto"+idComponente).className = "card mb-3 nascostoSuFront";
                    document.getElementById("iconaInvertiValoreNascosto"+idComponente).className = "far fa-eye";
                }
                
                $('#labelOperazioneCompletata').text(esito);
                $('#modalOperazioneCompletata').modal('show');
            },
            error: function() {
                alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
            }
        });
    }

    function cambiaIdElementoComponenteContenuto(idComponente) {
        var idElemento = $("#idElementoComponente"+idComponente).val();

        $.ajax({
            type:"GET",
            url:"../api/apiSistema.php",
            data:{
                operazione:"cambiaIdElementoComponenteContenuto",
                idComponente:idComponente,
                idElemento:idElemento
            },
            success:function(result) {
                if(result=="ok") {
                    $('#labelOperazioneCompletata').text("Componente aggiornato con successo");
                    $('#modalOperazioneCompletata').modal('show');
                    aggiornaComponentiContenuto();
                }
                else {
                    alert(result);
                }
            },
            error: function() {
                alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
            }
        });
    }
